import java.io.*;
import java.util.regex.*;

public class Main {
  public static void main (String args[]) {
    if(args.length < 1){
      System.out.println("Wywoanie programu: Main katalog maska");
      return;
    }

    File file = new File(args[0]);

    if(!file.exists()){
      System.out.println("Nie ma takiego katalogu.");
      return;
    }

    String[] dirList;

    if(args.length < 2){
      dirList = file.list();
    }
    else{
      dirList = file.list((FilenameFilter)new MyFileNameFilter(args[1]));
    }
    
    for(int i = 0; i < dirList.length; i++){
      System.out.println(dirList[i]);
    }
  }
}


class MyFileNameFilter implements FilenameFilter {
  Pattern pattern = null;
  public MyFileNameFilter(String mask) {
    try{
      pattern = Pattern.compile(mask);
    }
    catch(PatternSyntaxException e){
    }
  }
  public boolean accept(File dir, String name) {
    if(pattern == null){
      return false;
    }
    else{
      Matcher matcher = pattern.matcher(name);
      return matcher.matches();
    }
  }
}
